/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusFspms_error.h 59536 2016-03-03 10:46:35Z RalfH $

Description:
  This file contains Profibus FSPMS Task error codes

**************************************************************************************/
#ifndef __PROFIBUS_FSPMS_ERROR_H
#define __PROFIBUS_FSPMS_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS FSPMS Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PROFIBUS_FSPMS_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_PROFIBUS_FSPMS_COMMAND_INVALID ((TLR_RESULT)0xC0090001L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_MAX_EXT_DIAG_SIZE_EXCEEDED
//
// MessageText:
//
//  Setting the slave diagnostic failed, because the limit of the maximum number of 238 extended diagnostic bytes is exceeded.
//
#define TLR_E_PROFIBUS_FSPMS_MAX_EXT_DIAG_SIZE_EXCEEDED ((TLR_RESULT)0xC0090002L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_MAX_CFG_DATA_SIZE_EXCEEDED
//
// MessageText:
//
//  Setting the slave's configuration data failed, because the limit of the maximum number of 244 configuration bytes is exceeded.
//
#define TLR_E_PROFIBUS_FSPMS_MAX_CFG_DATA_SIZE_EXCEEDED ((TLR_RESULT)0xC0090003L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_MS0_INIT_WRONG_STATE
//
// MessageText:
//
//  The cyclic slave state machine cannot be initialized, state machine is not in "POWER-ON" state.
//
#define TLR_E_PROFIBUS_FSPMS_MS0_INIT_WRONG_STATE ((TLR_RESULT)0xC0090004L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SLAVE_DIAG_POWER_ON
//
// MessageText:
//
//  Setting the Slave Diagnostic Data cannot be performed, because slave state machine isn't initialized yet.
//
#define TLR_E_PROFIBUS_FSPMS_SLAVE_DIAG_POWER_ON ((TLR_RESULT)0xC0090005L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SET_CFG_POWER_ON
//
// MessageText:
//
//  Setting the Slave Configuration Data cannot be performed, because slave state machine isn't initialized yet.
//
#define TLR_E_PROFIBUS_FSPMS_SET_CFG_POWER_ON ((TLR_RESULT)0xC0090006L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_POWER_ON
//
// MessageText:
//
//  Getting the Slave Output Data cannot be performed, because slave state machine isn't initialized yet.
//
#define TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_POWER_ON ((TLR_RESULT)0xC0090007L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_WAIT_PRM
//
// MessageText:
//
//  Getting the Slave Output Data cannot be performed, because slave state is currently in state "WAIT-PRM".
//
#define TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_WAIT_PRM ((TLR_RESULT)0xC0090008L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SET_INPUT_POWER_ON
//
// MessageText:
//
//  Setting the Slave Input Data cannot be performed, because slave state machine isn't initialized yet.
//
#define TLR_E_PROFIBUS_FSPMS_SET_INPUT_POWER_ON ((TLR_RESULT)0xC0090009L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SET_INPUT_WAIT_PRM
//
// MessageText:
//
//  Setting the Slave Input Data cannot be performed, because slave state is currently in state "WAIT-PRM".
//
#define TLR_E_PROFIBUS_FSPMS_SET_INPUT_WAIT_PRM ((TLR_RESULT)0xC009000AL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_POWER_ON
//
// MessageText:
//
//  Confirming the Slave Parameter Data cannot be performed, because slave state machine isn't initialized yet.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_POWER_ON ((TLR_RESULT)0xC009000BL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_NOT_PENDING
//
// MessageText:
//
//  There is no Parameter Data checking command pending, command ignored.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_NOT_PENDING ((TLR_RESULT)0xC009000CL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_NEW_PARAMETER
//
// MessageText:
//
//  The confirmation of the Slave Parameter Data is obsolete, there is new Slave Parameter Data available.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_NEW_PARAMETER ((TLR_RESULT)0xC009000DL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_CFG_POWER_ON
//
// MessageText:
//
//  Confirming the Slave Configuration Data cannot be performed, because slave state machine isn't initialized yet.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_CFG_POWER_ON ((TLR_RESULT)0xC009000EL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_CFG_NOT_PENDING
//
// MessageText:
//
//  There is no Configuration Data checking command pending, command ignored.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_CFG_NOT_PENDING ((TLR_RESULT)0xC009000FL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_CFG_NEW_CONFIGURATION
//
// MessageText:
//
//  The confirmation of the Slave Configruation Data is obsolete, there is new Slave Configuration Data available.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_CFG_NEW_CONFIGURATION ((TLR_RESULT)0xC0090010L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_POWER_ON
//
// MessageText:
//
//  Confirming the extended Slave Parameter Data cannot be performed, because slave state machine isn't initialized yet.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_POWER_ON ((TLR_RESULT)0xC0090011L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_NOT_PENDING
//
// MessageText:
//
//  There is no extended Parameter Data checking command pending, command ignored.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_NOT_PENDING ((TLR_RESULT)0xC0090012L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_NEW_PARAMETER
//
// MessageText:
//
//  The confirmation of the extended Slave Parameter Data is obsolete, there is new extended Slave Parameter Data available.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_NEW_PARAMETER ((TLR_RESULT)0xC0090013L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_ABORT_IGNORED
//
// MessageText:
//
//  The abort command is ignored in the current state of the slave state machine.
//
#define TLR_E_PROFIBUS_FSPMS_ABORT_IGNORED ((TLR_RESULT)0xC0090014L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_WAIT_CFG
//
// MessageText:
//
//  Getting the Slave Output Data cannot be performed, because slave state is currently in state "WAIT-CFG".
//
#define TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_WAIT_CFG ((TLR_RESULT)0xC0090015L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SET_INPUT_NOT_PENDING
//
// MessageText:
//
//  Setting the Slave Input Data cannot be performed, because input update is not pending.
//
#define TLR_E_PROFIBUS_FSPMS_SET_INPUT_NOT_PENDING ((TLR_RESULT)0xC0090016L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_INVALID_MASTER_ADDRESS
//
// MessageText:
//
//  The confirmation of the Slave Parameter Data is obsolete, because meanwhile an other master has parameterized the slave.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_USER_PRM_INVALID_MASTER_ADDRESS ((TLR_RESULT)0xC0090017L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_CFG_INVALID_MASTER_ADDRESS
//
// MessageText:
//
//  The confirmation of the Slave Configruation Data is obsolete, because meanwhile an other master has configured the slave.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_CFG_INVALID_MASTER_ADDRESS ((TLR_RESULT)0xC0090018L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_APPLICATION_READY_IGNORED
//
// MessageText:
//
//  The Application ready command is ignored in the current state of the slave state machine.
//
#define TLR_E_PROFIBUS_FSPMS_APPLICATION_READY_IGNORED ((TLR_RESULT)0xC0090019L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_INVALID_MASTER_ADDRESS
//
// MessageText:
//
//  The confirmation of the extended Slave Parameter Data is obsolete, because meanwhile an other master has parameterized the slave.
//
#define TLR_E_PROFIBUS_FSPMS_CHECK_EXT_USER_PRM_INVALID_MASTER_ADDRESS ((TLR_RESULT)0xC009001AL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_DATA_EXCHANGE_NO_CYCLE
//
// MessageText:
//
//  Getting the Slave Output Data cannot be performed, because slave state machine is in state "DATA-EXCH" but no output cycle has been driven yet.
//
#define TLR_E_PROFIBUS_FSPMS_GET_OUTPUT_DATA_EXCHANGE_NO_CYCLE ((TLR_RESULT)0xC009001BL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_APPLICATION_ALREADY_READY
//
// MessageText:
//
//  The Application ready command is ignored, because the application has already signaled its readyness.
//
#define TLR_E_PROFIBUS_FSPMS_APPLICATION_ALREADY_READY ((TLR_RESULT)0xC009001CL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SLAVE_DIAG_PENDING
//
// MessageText:
//
//  A new Slave Diagnostic command can not be accepted, while a previous one is pending.
//
#define TLR_E_PROFIBUS_FSPMS_SLAVE_DIAG_PENDING ((TLR_RESULT)0xC009001DL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_READ_RESPONSE_NEG
//
// MessageText:
//
//  The read command can not be A new Slave Diagnostic command can not be accepted, while a previous one is pending.
//
#define TLR_E_PROFIBUS_FSPMS_READ_RESPONSE_NEG ((TLR_RESULT)0xC009001EL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_MS1_INIT_WRONG_STATE
//
// MessageText:
//
//  The acyclic slave state machine cannot be initialized, state machine is not in "POWER-ON" state.
//
#define TLR_E_PROFIBUS_FSPMS_MS1_INIT_WRONG_STATE ((TLR_RESULT)0xC009001FL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_NOT_STARTED
//
// MessageText:
//
//  The Alarm Handler state machine isn't started yet, an Alarm cannot be notified.
//
#define TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_NOT_STARTED ((TLR_RESULT)0xC0090020L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_NOT_ENABLED
//
// MessageText:
//
//  The requested Type of Alarm is not enabled, this Alarm cannot be notified.
//
#define TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_NOT_ENABLED ((TLR_RESULT)0xC0090022L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_LIMIT_EXPIRED
//
// MessageText:
//
//  The limit of parallel running alarms is expired, this Alarm cannot be notified.
//
#define TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_LIMIT_EXPIRED ((TLR_RESULT)0xC0090023L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_PENDING
//
// MessageText:
//
//  This requested Type of Alarm is still pending and in operation, this is why the Alarm cannot be notified.
//
#define TLR_E_PROFIBUS_FSPMS_ALARM_HANDLER_PENDING ((TLR_RESULT)0xC0090024L)

//
// MessageId: TLR_W_PROFIBUS_FSPMS_NOTREADY_EXPIRED
//
// MessageText:
//
//  Application is at not ready state.
//
#define TLR_W_PROFIBUS_FSPMS_NOTREADY_EXPIRED ((TLR_RESULT)0x80090025L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_WATCHDOG_EXPIRED
//
// MessageText:
//
//  Watchdog error expired.
//
#define TLR_E_PROFIBUS_FSPMS_WATCHDOG_EXPIRED ((TLR_RESULT)0xC0090026L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SUBSCRIBER_NOT_CONFIGURED
//
// MessageText:
//
//  Subscriber with given address not configured.
//
#define TLR_E_PROFIBUS_FSPMS_SUBSCRIBER_NOT_CONFIGURED ((TLR_RESULT)0xC0090027L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SUBSCRIBER_NOT_IN_WSTART_STATE
//
// MessageText:
//
//  Subscriber in wrong state, state w_start expected.
//
#define TLR_E_PROFIBUS_FSPMS_SUBSCRIBER_NOT_IN_WSTART_STATE ((TLR_RESULT)0xC0090028L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_SUBSCRIBER_NOT_IN_RUN_STATE
//
// MessageText:
//
//  Subscriber in wrong state, state run expected.
//
#define TLR_E_PROFIBUS_FSPMS_SUBSCRIBER_NOT_IN_RUN_STATE ((TLR_RESULT)0xC0090029L)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CLOCKSYNC_ALREADY_RUNNING
//
// MessageText:
//
//  ClockSync in wrong state, already running.
//
#define TLR_E_PROFIBUS_FSPMS_CLOCKSYNC_ALREADY_RUNNING ((TLR_RESULT)0xC009002AL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_CLOCKSYNC_NOT_RUNNING
//
// MessageText:
//
//  ClockSync in wrong state, not running.
//
#define TLR_E_PROFIBUS_FSPMS_CLOCKSYNC_NOT_RUNNING ((TLR_RESULT)0xC009002BL)

//
// MessageId: TLR_E_PROFIBUS_FSPMS_RESET_PENDING
//
// MessageText:
//
//  Reset of FSPMS task is pending.
//
#define TLR_E_PROFIBUS_FSPMS_RESET_PENDING ((TLR_RESULT)0xC009002CL)




#endif  //__PROFIBUS_FSPMS_ERROR_H

